
#include "TimerOne.h"
#include "TimerThree.h"
#include <EEPROM.h>

#define DEBOUNCE 8
#define PWMPERIOD 12

int potPin = A6;
int redLEDPin = 5;
int yellowLEDPin = 6;
int greenLEDPin = 7;
int pwmPin = 10;
int counter1pin = 2;
int counter2pin = 19;
int counter3pin = 20;
int counter4pin = 21;
int buttonPin = 18;
int piezoPin1 = 8;
int piezoPin2 = 9;
int potValue = 0;
int cur_counters[4], last_counters[4], nominal_counters[4];
unsigned char counter_states[4], button_state, button_pressed, sound_piezo;
unsigned char t3overflow;

void timer3overflow()
{
  t3overflow = 1;
}

#define CLOCK_PRESCALER_1   (0x0)
#define CLOCK_PRESCALER_2   (0x1)
#define CLOCK_PRESCALER_4   (0x2)
#define CLOCK_PRESCALER_8   (0x3)
#define CLOCK_PRESCALER_16  (0x4)
#define CLOCK_PRESCALER_32  (0x5)
#define CLOCK_PRESCALER_64  (0x6)
#define CLOCK_PRESCALER_128 (0x7)
#define CLOCK_PRESCALER_256 (0x8)

static uint8_t __clock_prescaler = (CLKPR & (_BV(CLKPS0) | _BV(CLKPS1) | _BV(CLKPS2) | _BV(CLKPS3)));

inline void setClockPrescaler(uint8_t clockPrescaler) {
  if (clockPrescaler <= CLOCK_PRESCALER_256) {
    // Disable interrupts.
    uint8_t oldSREG = SREG;
    cli();

    // Enable change.
    CLKPR = _BV(CLKPCE); // write the CLKPCE bit to one and all the other to zero

    // Change clock division.
    CLKPR = clockPrescaler; // write the CLKPS0..3 bits while writing the CLKPE bit to zero

    // Copy for fast access.
    __clock_prescaler = clockPrescaler;

    // Recopy interrupt register.
    SREG = oldSREG;
  }
}

void setup() {
  setClockPrescaler(CLOCK_PRESCALER_1);

  nominal_counters[0] = EEPROM.read(0);
  nominal_counters[1] = EEPROM.read(1);
  nominal_counters[2] = EEPROM.read(2);
  nominal_counters[3] = EEPROM.read(3);

//  Serial.begin(9600);

  pinMode(redLEDPin, OUTPUT);
  digitalWrite(redLEDPin, HIGH);
  pinMode(yellowLEDPin, OUTPUT);
  digitalWrite(yellowLEDPin, HIGH);
  pinMode(greenLEDPin, OUTPUT);
  digitalWrite(greenLEDPin, HIGH);
  pinMode(piezoPin1, OUTPUT);
  digitalWrite(piezoPin1, LOW);
  pinMode(piezoPin2, OUTPUT);
  digitalWrite(piezoPin2, LOW);

//  pinMode(ledPin, OUTPUT);
  pinMode(pwmPin, OUTPUT);
  pinMode(counter1pin, INPUT);
  digitalWrite(counter1pin, HIGH);
  pinMode(counter2pin, INPUT);
  digitalWrite(counter2pin, HIGH);
  pinMode(counter3pin, INPUT);
  digitalWrite(counter3pin, HIGH);
  pinMode(counter4pin, INPUT);
  digitalWrite(counter4pin, HIGH);
  pinMode(buttonPin, INPUT);
  digitalWrite(buttonPin, HIGH);
  Timer1.initialize(PWMPERIOD);
  Timer3.initialize(1000000);
  Timer3.attachInterrupt(timer3overflow);
}

void loop() {
  if( t3overflow ) {
    memcpy(last_counters, cur_counters, sizeof(last_counters));
    memset(cur_counters, 0, sizeof(cur_counters));
    t3overflow = 0;
/*    
    Serial.print(512 + potValue * 2);
    Serial.print("; ");
    Serial.print(last_counters[0]);
    Serial.print(", ");
    Serial.print(last_counters[1]);
    Serial.print(", ");
    Serial.print(last_counters[2]);
    Serial.print(", ");
    Serial.print(last_counters[3]);
    Serial.print("\n");
*/
  }

  if( !digitalRead(counter1pin) ) {
    if( counter_states[0] < DEBOUNCE )
      ++counter_states[0];
    else if( counter_states[0] > DEBOUNCE )
      counter_states[0] = DEBOUNCE;
  } else {
    if( counter_states[0] == (DEBOUNCE*2) )
      ++cur_counters[0];
    if( counter_states[0] >= DEBOUNCE && counter_states[0] <= (DEBOUNCE*2) )
      ++counter_states[0];
    else
      counter_states[0] = 0;
  }
  if( !digitalRead(counter2pin) ) {
    if( counter_states[1] < DEBOUNCE )
      ++counter_states[1];
    else if( counter_states[1] > DEBOUNCE )
      counter_states[1] = DEBOUNCE;
  } else {
    if( counter_states[1] == (DEBOUNCE*2) )
      ++cur_counters[1];
    if( counter_states[1] >= DEBOUNCE && counter_states[1] <= (DEBOUNCE*2) )
      ++counter_states[1];
    else
      counter_states[1] = 0;
  }
  if( !digitalRead(counter3pin) ) {
    if( counter_states[2] < DEBOUNCE )
      ++counter_states[2];
    else if( counter_states[2] > DEBOUNCE )
      counter_states[2] = DEBOUNCE;
  } else {
    if( counter_states[2] == (DEBOUNCE*2) )
      ++cur_counters[2];
    if( counter_states[2] >= DEBOUNCE && counter_states[2] <= (DEBOUNCE*2) )
      ++counter_states[2];
    else
      counter_states[2] = 0;
  }
  if( !digitalRead(counter4pin) ) {
    if( counter_states[3] < DEBOUNCE )
      ++counter_states[3];
    else if( counter_states[3] > DEBOUNCE )
      counter_states[3] = DEBOUNCE;
  } else {
    if( counter_states[3] == (DEBOUNCE*2) )
      ++cur_counters[3];
    if( counter_states[3] >= DEBOUNCE && counter_states[3] <= (DEBOUNCE*2) )
      ++counter_states[3];
    else
      counter_states[3] = 0;
  }
  if( !digitalRead(buttonPin) ) {
    if( button_state < DEBOUNCE )
      ++button_state;
    else if( button_state > DEBOUNCE )
      button_state = DEBOUNCE;
  } else {
    if( button_state == (DEBOUNCE*2) )
      button_pressed = 1;
    if( button_state >= DEBOUNCE && button_state <= (DEBOUNCE*2) )
      ++button_state;
    else
      button_state = 0;
  }

  // read the value from the sensor:
  potValue = analogRead(potPin);
  if( potValue > 511 )
    potValue = 0;
  else
    potValue = (511 - potValue) / 2;

  if( button_pressed ) {
    button_pressed = 0;
    nominal_counters[0] = last_counters[0];
    nominal_counters[1] = last_counters[1];
    nominal_counters[2] = last_counters[2];
    nominal_counters[3] = last_counters[3];
    EEPROM.write(0, nominal_counters[0]);
    EEPROM.write(1, nominal_counters[1]);
    EEPROM.write(2, nominal_counters[2]);
    EEPROM.write(3, nominal_counters[3]);
  }

  if( last_counters[0] >= nominal_counters[0]*9/10 &&
      last_counters[1] >= nominal_counters[1]*9/10 &&
      last_counters[2] >= nominal_counters[2]*9/10 &&
      last_counters[3] >= nominal_counters[3]*9/10 ) {
    digitalWrite(redLEDPin, HIGH);
    digitalWrite(yellowLEDPin, HIGH);
    digitalWrite(greenLEDPin, LOW);
    sound_piezo = 0;
  } else
  if( last_counters[0] >= nominal_counters[0]*8/10 &&
      last_counters[1] >= nominal_counters[1]*8/10 &&
      last_counters[2] >= nominal_counters[2]*8/10 &&
      last_counters[3] >= nominal_counters[3]*8/10 ) {
    digitalWrite(redLEDPin, HIGH);
    digitalWrite(yellowLEDPin, LOW);
    digitalWrite(greenLEDPin, HIGH);
    sound_piezo = 0;
  } else {
    digitalWrite(redLEDPin, LOW);
    digitalWrite(yellowLEDPin, HIGH);
    digitalWrite(greenLEDPin, HIGH);
    potValue = 255;
    sound_piezo = TCNT3 < ICR3 / 4;
  }

  Timer1.pwm(pwmPin, 512 + potValue * 2, PWMPERIOD);
  digitalWrite(piezoPin1, sound_piezo);
  digitalWrite(piezoPin2, sound_piezo);
}

